<?php
require_once __DIR__.'/maincore.php';
require_once THEMES.'templates/header.php';
add_to_head('<style>
body { font-size: 19px; }
    h3 { font-size: 24px; }
    label { font-size: 24px; }
    .btn { font-size: 18px; }
    .txt-php { color: blue; }
    .txt-txt { color: brown; }
    .txt-swf { color: red; }
    .txt-ttf { color: purple; }
    .txt-png { color: green; }
    .txt-jpg { color: orange; }
    .txt-js { color: teal; }
    .txt-inc { color: darkviolet; }
    .txt-json { color: darkgreen; }
    .txt-less { color: darkblue; }
    .txt-combine { color: darkcyan; }
    .txt-md { color: darkslategray; }
    .txt-css { color: coral; }
    .txt-gif { color: pink; }
    .txt-types { color: gold; }
    .txt-sql { color: navy; }
    .txt-svg { color: magenta; }
    .txt-woff2 { color: lightseagreen; }
    .txt-eot { color: lightcoral; }
    .txt-woff { color: lightblue; }
    .txt-wav { color: lightgray; }
    .txt-mo { color: darkorange; }
    .txt-po { color: darkred; }
    .txt-html { color: darkkhaki; }
    .txt-htaccess { color: darkslateblue; }
    .txt-ico { color: darkgoldenrod; }
</style>
');

// Lista dostępnych katalogów
$directories = ['infusions', 'includes', 'administration', 'images', 'locale', 'themes','infusions/forum/attachments'];

// Sprawdzenie, czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['directory'])) {
    $selected_directory = $_POST['directory'];
    
    // Sprawdzenie, czy wybrany katalog jest na liście
    if (in_array($selected_directory, $directories)) {
        $file_counts = get_files_count($selected_directory);
        
        // Wyświetlanie wyników
        echo "<h3>Wyniki dla katalogu: $selected_directory</h3>";
        foreach ($file_counts as $ext => $count) {
            // Ustalanie klasy CSS na podstawie rozszerzenia
            $class = 'txt-' . $ext;
            echo "Mamy <span class=\"$class\">$count</span> plików o rozszerzeniu <span class=\"$class\">.$ext</span> w katalogu $selected_directory<br>";
        }
    } else {
        echo "Wybrano nieprawidłowy katalog.";
    }
}

// Wyświetlenie formularza
echo '<form method="post" action="" class="form-inline">';
echo '<div class="form-group">';
echo '<label for="directory" class="sr-only">Wybierz katalog:</label>';
echo '<select name="directory" id="directory" class="form-control">';
foreach ($directories as $dir) {
    echo "<option value=\"$dir\">$dir</option>";
}
echo '</select>';
echo '</div>';
echo '<button type="submit" class="btn btn-primary">Zlicz pliki</button>';
echo '</form>';

function is_valid_file($filename) {
    return (!in_array($filename, array(".", "..", "/", "index.php", "index.html", ".ftpquota")) && !is_dir($filename));
}

function get_files_count($dir) {
    $result = [];
    $dh = opendir($dir);
    
    if ($dh) {
        while (($filename = readdir($dh)) !== false) {
            // Pomijamy "." i ".."
            if ($filename != "." && $filename != "..") {
                $path = $dir . '/' . $filename;
                if (is_dir($path)) {
                    // Jeśli to folder, wywołujemy funkcję rekurencyjnie
                    $sub_result = get_files_count($path);
                    foreach ($sub_result as $ext => $count) {
                        if (isset($result[$ext])) {
                            $result[$ext] += $count;
                        } else {
                            $result[$ext] = $count;
                        }
                    }
                } elseif (is_valid_file($filename)) {
                    // Jeśli to plik, zwiększamy licznik dla odpowiedniego rozszerzenia
                    $ext = pathinfo($filename, PATHINFO_EXTENSION);
                    if (isset($result[$ext])) {
                        $result[$ext]++;
                    } else {
                        $result[$ext] = 1;
                    }
                }
            }
        }
        closedir($dh);
    }
    
    return $result;
}

require_once THEMES.'templates/footer.php';
?>
