<?php
if (!defined("IN_FUSION")) {
    header("Location: /error.php");
    exit;
}

// === MAGYAR RÁDIÓ – rozszerzona lista stacji ===
$radios = array(
    "radio1"       => array("name" => "Rádió 1",               "url" => "https://icast.connectmedia.hu/5201/live.mp3"),
    "bestfm"       => array("name" => "Best FM Budapest",      "url" => "http://stream.webthings.hu:8000/fm95-x-128.mp3"),
    "dance_wave"   => array("name" => "Dance Wave!",           "url" => "http://dancewave.hopto.org/dance.mp3"),
    "jazzy"        => array("name" => "Jazzy 90.9 Rádió",       "url" => "http://94.199.183.186/jazzy.mp3"),
    "luxfunk"      => array("name" => "Luxfunk Radio",         "url" => "http://37.221.209.146:5000/luxfunkdance.mp3"),
    "klasszik92"   => array("name" => "Klasszik Rádió 92.1",   "url" => "http://icast.connectmedia.hu/4784/live.mp3"),
    "poptarisznya" => array("name" => "Poptarisznya",          "url" => "http://adas.poptarisznya.hu:8200/live.mp3"),
    "pr2"          => array("name" => "Radio Plus",            "url" => "https://pl03.cdn.eurozet.pl/plu-waw.mp3?seen=1"),
    "rmf"          => array("name" => "RMF FM",                "url" => "https://rs9-krk2.rmfstream.pl/rmf_fm"),
    "techno"       => array("name" => "Technobase FM",         "url" => "https://mp3.stream.tb-group.fm/tb.mp3"),
    "eska"         => array("name" => "Radio ESKA",            "url" => "https://radio.stream.smcdn.pl/icradio-p/2380-1.aac/playlist.m3u8"),
    "vox"          => array("name" => "Radio VOX FM",          "url" => "https://radio.stream.smcdn.pl/icradio-p/3990-1.aac/playlist.m3u8"),
    "pr1"          => array("name" => "Polskie Radio Jedynka", "url" => "https://stream11.polskieradio.pl/pr1/pr1.sdp/chunklist_w139946047.m3u8"),
    "pr3"          => array("name" => "Polskie Radio Trójka",  "url" => "https://stream13.polskieradio.pl/pr3/pr3.sdp/chunklist_w267165089.m3u8")
);

// Wybrana stacja: POST > GET > domyślna
$selected = isset($_POST['radio']) ? $_POST['radio'] : (isset($_GET['radio']) ? $_GET['radio'] : 'radio1');
if (!array_key_exists($selected, $radios)) {
    $selected = 'radio1';
}

$streamUrl  = $radios[$selected]['url'];
$streamName = $radios[$selected]['name'];

opentable('Magyar Rádió 🎧 <strong>' . htmlspecialchars($streamName, ENT_QUOTES, 'UTF-8') . '</strong>');
?>
<div style="padding:10px; font-size:0.95em;">
    <form method="post" style="margin-bottom:12px;">
        <label for="radio-select" style="display:block; margin-bottom:8px; font-weight:bold;">
            Válassz rádióállomást:
        </label>
        <select id="radio-select" name="radio" onchange="this.form.submit()" class="form-control" style="width:100%;">
            <?php foreach ($radios as $key => $radio) { ?>
                <option value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>"
                    <?php echo ($key === $selected) ? 'selected="selected"' : ''; ?>>
                    <?php echo htmlspecialchars($radio['name'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php } ?>
        </select>
    </form>
    <audio id="radio-player" controls preload="none" style="width:100%; height:38px;">
        <source src="<?php echo htmlspecialchars($streamUrl, ENT_QUOTES, 'UTF-8'); ?>" type="audio/mpeg">
        <source src="<?php echo htmlspecialchars($streamUrl, ENT_QUOTES, 'UTF-8'); ?>" type="application/x-mpegurl">
        Twoja przeglądarka nie obsługuje odtwarzacza audio.
    </audio>
</div> <?php
closetable();

// === HLS támogatás ===
add_to_footer("<script src='".INFUSIONS."radio_panel/hls.min.js' defer></script>");
add_to_footer('<script>
document.addEventListener("DOMContentLoaded", function () {
    const streamUrl = "' . htmlspecialchars($streamUrl, ENT_QUOTES) . '";
    const audio = document.getElementById("radio-player");
    if (!audio) return;

    if (typeof Hls !== "undefined" && Hls.isSupported() && streamUrl.endsWith(".m3u8")) {
        const hls = new Hls();
        hls.loadSource(streamUrl);
        hls.attachMedia(audio);
        hls.on(Hls.Events.MANIFEST_PARSED, () => {
            audio.play().catch(() => {});
        });
    } else {
        audio.src = streamUrl;
    }
});
</script>');
?>
